<?php
/***********************************************************************/
/** \file   c_comdef_changes.class.php
    \brief The file for the c_comdef_changes class.

    This file is part of the Basic Meeting List Toolbox (BMLT).

    Find out more at: https://bmlt.app

    BMLT is free software: you can redistribute it and/or modify
    it under the terms of the MIT License.

    BMLT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    MIT License for more details.

    You should have received a copy of the MIT License along with this code.
    If not, see <https://opensource.org/licenses/MIT>.
*/
defined('BMLT_EXEC') or die('Cannot Execute Directly');    // Makes sure that this file is in the correct context.

require_once(dirname(__FILE__)."/c_comdef_change.class.php");

/***********************************************************************/
/** \class c_comdef_changes
    \brief  A class to hold a collection of c_comdef_change objects.

***********************************************************************/
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
// phpcs:disable Squiz.Classes.ValidClassName.NotCamelCaps
class c_comdef_changes implements i_comdef_has_parent
// phpcs:enable PSR1.Classes.ClassDeclaration.MissingNamespace
// phpcs:enable Squiz.Classes.ValidClassName.NotCamelCaps
{
    /// A reference to the "parent" object for this instance.
    private $_local_id_parent_obj = null;
    /// An array of new c_comdef_change objects that comprises the content.
    private $_changes_objects = null;

    public function __construct(
        $in_parent_object,      ///< A reference to the object that "owns" this instance.
        $in_change_data         ///< An array of data for the changes to be instantiated.
    ) {
        $this->SetParentObj($in_parent_object);
        
        if (is_array($in_change_data) && count($in_change_data)) {
            $count = 0;
            foreach ($in_change_data as $row) {
                $this->_changes_objects[$count] = null;
                $date_ar = explode(" ", $row['change_date']);
                $date_a = explode("-", $date_ar[0]);
                $date_b = explode(":", $date_ar[1]);
                $date = mktime($date_b[0], $date_b[1], $date_b[2], $date_a[1], $date_a[2], $date_a[0]);
                $this->_changes_objects[$count++] = new c_comdef_change($this, $row['change_type_enum'], $row['user_id_bigint'], $row['service_body_id_bigint'], $row['before_object'], $row['after_object'], $row['object_class_string'], $row['before_id_bigint'], $row['after_id_bigint'], $row['before_lang_enum'], $row['after_lang_enum'], $row['id_bigint'], $row['change_name_string'], $row['change_description_text'], $row['lang_enum'], $date);
            }
        }
    }
    
    /*******************************************************************/
    /** \brief Accessor. Get references to the changes objects.

        \returns a reference to an array of c_comdef_changes objects.
    */
    // phpcs:disable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
    public function &GetChangesObjects()
    {
        // phpcs:enable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
        return $this->_changes_objects;
    }
    
    /*******************************************************************/
    /** \brief Set the parent object of this instance.
    */
    // phpcs:disable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
    public function SetParentObj(
        $in_parent_obj  ///< A reference to the parent object.
    ) {
        // phpcs:enable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
        $this->_local_id_parent_obj = null;
        $this->_local_id_parent_obj = $in_parent_obj;
    }
    
    /*******************************************************************/
    /** \brief Return a reference to the parent object of this instance.

        \returns a reference to the parent instance of the object.
    */
    // phpcs:disable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
    public function GetParentObj()
    {
        // phpcs:enable PSR1.Methods.CamelCapsMethodName.NotCamelCaps
        return $this->_local_id_parent_obj;
    }
}
