<?php
/***********************************************************************/
/** \file   server_admin_strings.inc.php
 * \brief  The strings displayed in the server administration console (Spanish)
 *
 * This file is part of the Basic Meeting List Toolbox (BMLT).
 *
 * Find out more at: https://bmlt.app
 *
 * BMLT is free software: you can redistribute it and/or modify
 * it under the terms of the MIT License.
 *
 * BMLT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * MIT License for more details.
 *
 * You should have received a copy of the MIT License along with this code.
 * If not, see <https://opensource.org/licenses/MIT>. */

defined('BMLT_EXEC') or die('Cannot Execute Directly');    // Makes sure that this file is in the correct context.

$comdef_server_admin_strings = array('server_admin_disclosure' => 'Server Administration',
    'server_admin_naws_spreadsheet_label' => 'Updated World Committee Codes Spreadsheet',
    'update_world_ids_button_text' => 'Update World Committee Codes',
    'update_world_ids_from_spreadsheet_dropdown_text' => 'Update World Committee Codes (Group IDs from NAWS) from NAWS Spreadsheet',
    'server_admin_error_no_world_ids_updated' => 'No World IDs were updated. This could be because your user does not have permission to update the submitted meetings.',
    'server_admin_error_required_spreadsheet_column' => 'Required column does not exist in the spreadsheet: ',
    'server_admin_error_bmlt_id_not_integer' => 'The provided bmlt_id is not an integer: ',
    'server_admin_error_could_not_create_reader' => 'Could not create reader for file: ',
    'server_admin_error_no_files_uploaded' => 'No files were uploaded.',
    'server_admin_error_service_bodies_already_exist' => 'Service bodies with the following World IDs already exist: ',
    'server_admin_error_meetings_already_exist' => 'Meetings with the following World IDs already exist: ',
    'server_admin_ui_num_meetings_updated' => 'Number of meetings updated: ',
    'server_admin_ui_num_meetings_not_updated' => 'Number of meetings that did not need updating: ',
    'server_admin_ui_warning' => 'WARNING',
    'server_admin_ui_errors' => 'Error(s)',
    'server_admin_ui_deleted_meetings_marked' => 'Number of deleted meetings marked so that they won\'t appear in future NAWS exports: ',
    'server_admin_ui_problem_meetings' => 'meetings were found in the spreadsheet that couldn\'t be updated. Problem meeting IDs: ',
    'server_admin_ui_service_bodies_created' => 'Service bodies created: ',
    'server_admin_ui_meetings_created' => 'Meetings created: ',
    'server_admin_ui_users_created' => 'Users created: ',
    'server_admin_ui_refresh_ui_text' => 'Sign out and then sign in again to see the new service bodies, users, and meetings.',
    'import_service_bodies_and_meetings_button_text' => 'Import Service Bodies and Meetings',
    'import_service_bodies_and_meetings_dropdown_text' => 'Import Service Bodies and Meetings from NAWS Export',
    'server_admin_naws_import_spreadsheet_label' => 'NAWS Import Spreadsheet:',
    'server_admin_naws_import_initially_publish' => 'Initialize imported meetings to \'published\': ',
    'server_admin_naws_import_explanation' => 'Uncheck the box to initialize imported meetings to \'unpublished\'. (This is useful if many of the new meetings will need to be edited or deleted, and you don\'t want them showing up in the meantime.)',
    'account_disclosure' => 'Mi cuenta',
    'account_name_label' => 'Nombre de cuenta:',
    'account_login_label' => 'Mi nombre de usuario:',
    'account_type_label' => 'Soy:',
    'account_type_1' => 'Administrador de servidor',
    'account_type_2' => 'Administrador de cuerpo de servicio',
    'ServerMapsURL' => 'https://maps.googleapis.com/maps/api/geocode/xml?address=##SEARCH_STRING##&sensor=false',
    'account_type_4' => 'Pathetic Luser Who Shouldn\'t Even Have Access to This Page -The Author of the Software Pooched it BAD!',
    'account_type_5' => 'Observador de cuerpo de servicio',
    'change_password_label' => 'Cambiar mi contraseña para:',
    'change_password_default_text' => 'Deja eso si usted no desea cambiar su contraseña',
    'account_email_label' => 'Mi dirección de correo electrónico:',
    'email_address_default_text' => 'Introduzca una dirección de correo',
    'account_description_label' => 'Mi descripción:',
    'account_description_default_text' => 'Escriba una descripción',
    'account_change_button_text' => 'Cambiar configuración de mi cuenta',
    'account_change_fader_success_text' => 'La información de la cuenta se cambió con éxito',
    'account_change_fader_failure_text' => 'La información de la cuenta no se ha modificado',
    'meeting_editor_disclosure' => 'Editor de reuniones',
    'meeting_editor_already_editing_confirm' => 'En este momento está editando una nueva reunión. ¿Quieres perder todos los cambios en esa reunión?',
    'meeting_change_fader_success_text' => 'La reunión se cambió con éxito',
    'meeting_change_fader_failure_text' => 'La reunión no se ha modificado',
    'meeting_change_fader_success_delete_text' => 'La reunión se ha eliminado correctamente',
    'meeting_change_fader_fail_delete_text' => 'La reunión no se ha eliminado',
    'meeting_change_fader_success_add_text' => 'La nueva reunión se agregó con exito',
    'meeting_change_fader_fail_add_text' => 'La nueva reunión no fue añadida',
    'meeting_text_input_label' => 'Buscar texto:',
    'access_service_body_label' => 'Tengo acceso a:',
    'meeting_text_input_default_text' => 'Introduzca algun texto de búsqueda',
    'meeting_text_location_label' => 'Se trata de una localidad o código postal',
    'meeting_search_weekdays_label' => 'Búsqueda para los días laborables seleccionados:',
    'meeting_search_weekdays_names' => array('Todos', 'Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'),
    'meeting_search_service_bodies_label' => 'Buscar en los cuerpos de servicio seleccionados:',
    'meeting_search_start_time_label' => 'Buscar reuniónes por hora de inicio:',
    'meeting_search_start_time_all_label' => 'Cualquier horario',
    'meeting_search_start_time_morn_label' => 'Por la mañana',
    'meeting_search_start_time_aft_label' => 'Por la tarde',
    'meeting_search_start_time_eve_label' => 'Por la noche',
    'meeting_search_no_results_text' => 'No hay reuniones encontradas',
    'meeting_editor_tab_specifier_text' => 'Buscar por reuniones',
    'meeting_editor_tab_editor_text' => 'Editar reuniones',   // TODO: change to 'Edit Or Create Meetings'
    'meeting_editor_create_new_text' => 'Crear una nueva reunión',
    'meeting_editor_location_map_link' => 'Mapa de localización',
    'meeting_editor_screen_match_ll_button' => 'Establezca longitud y la latitud a dirección',
    'meeting_editor_screen_default_text_prompt' => 'Escriba un texto o un número',
    'meeting_is_published' => 'Reunión es publicado',
    'meeting_unpublished_note' => 'Note: Unpublishing a meeting indicates a temporary closure. If this meeting has closed permanently, please delete it.',
    'meeting_editor_screen_meeting_name_label' => 'Nombre de la reunión:',
    'meeting_editor_screen_meeting_name_prompt' => 'Introduzca un nombre de reunión',
    'meeting_editor_screen_meeting_weekday_label' => 'Día de semana:',
    'meeting_editor_screen_meeting_start_label' => 'Hora de inicio de reunion:',
    'meeting_editor_screen_meeting_time_zone_label' => 'Meeting Time Zone:',
    'meeting_editor_screen_meeting_am_label' => 'AM',
    'meeting_editor_screen_meeting_pm_label' => 'PM',
    'meeting_editor_screen_meeting_noon_label' => 'Mediodía',
    'meeting_editor_screen_meeting_midnight_label' => 'Medianoche',
    'meeting_editor_screen_meeting_duration_label' => 'Duración:',
    'meeting_editor_screen_meeting_oe_label' => 'De composición abierta',
    'meeting_editor_screen_meeting_cc_label' => 'Código Comité Mundial:',
    'meeting_editor_screen_meeting_cc_advice' => 'Normally leave this field alone (see documentation).',  // TODO: translate
    'meeting_editor_screen_meeting_contact_label' => 'Contacto correo electonico de reunion:',
    'meeting_editor_screen_meeting_contact_prompt' => 'Escriba un correo electrónico de un contacto específico sólo a esta reunión',
    'meeting_editor_screen_meeting_sb_label' => 'Cuerpo de Servicio:',
    'meeting_editor_screen_meeting_sb_default_value' => 'Ningún cuerpo de servicio seleccionado',
    'meeting_editor_screen_meeting_longitude_label' => 'Longitud:',
    'meeting_editor_screen_meeting_longitude_prompt' => 'Escriba una Longitud',
    'meeting_editor_screen_meeting_latitude_label' => 'Latitud:',
    'meeting_editor_screen_meeting_latitude_prompt' => 'Introduzca Un Latitud',
    'meeting_editor_screen_meeting_location_label' => 'Ubicación:',
    'meeting_editor_screen_meeting_location_prompt' => 'Introduzca un Nombre de ubicación (como un nombre del edificio)',
    'meeting_editor_screen_meeting_info_label' => 'Información complementaria:',
    'meeting_editor_screen_meeting_info_prompt' => 'Introduzca cualquier información adicional sobre la ubicación',
    'meeting_editor_screen_meeting_street_label' => 'Dirección:',
    'meeting_editor_screen_meeting_street_prompt' => 'Introduzca una Dirección',
    'meeting_editor_screen_meeting_neighborhood_label' => 'Barrio:',
    'meeting_editor_screen_meeting_neighborhood_prompt' => 'Introduzca un Barrio (No municipio o ciudad subsección)',
    'meeting_editor_screen_meeting_borough_label' => 'Municipio/Ciudad Subsección:',
    'meeting_editor_screen_meeting_borough_prompt' => 'Ingresa una ciudad o ciudad subsección (No Barrio)',
    'meeting_editor_screen_meeting_city_label' => 'Ciudad/Pueblo:',
    'meeting_editor_screen_meeting_city_prompt' => 'Ingresa la ciudad o nombre del pueblo (no condado o municipal)',
    'meeting_editor_screen_meeting_county_label' => 'Condado/Sub-Provincia:',
    'meeting_editor_screen_meeting_county_prompt' => 'Introduzca un condado o nombre Sub-Provincia',
    'meeting_editor_screen_meeting_state_label' => 'Estado/Provincia:',
    'meeting_editor_screen_meeting_state_prompt' => 'Entrar un nombre de estado o provincia',
    'meeting_editor_screen_meeting_zip_label' => 'Código Postal:',
    'meeting_editor_screen_meeting_zip_prompt' => 'Ingrese un Código Postal',
    'meeting_editor_screen_meeting_nation_label' => 'Nación:',
    'meeting_editor_screen_meeting_nation_prompt' => 'Introduzca el nombre de la nación',
    'meeting_editor_screen_meeting_comments_label' => 'Comments:',
    'meeting_editor_screen_meeting_train_lines_label' => 'Train Lines:',
    'meeting_editor_screen_meeting_bus_lines_label' => 'Bus Lines:',
    'meeting_editor_screen_meeting_phone_meeting_number_label' => 'Phone Meeting Dial-in Number:',
    'meeting_editor_screen_meeting_phone_meeting_number_prompt' => 'Enter the dial-in number for a phone or virtual meeting',
    'meeting_editor_screen_meeting_virtual_meeting_link_label' => 'Virtual Meeting Link:',
    'meeting_editor_screen_meeting_virtual_meeting_link_prompt' => 'Enter the link for a virtual meeting',
    'meeting_editor_screen_meeting_virtual_meeting_additional_info_label' => 'Virtual Meeting Additional Information:',
    'meeting_editor_screen_meeting_virtual_meeting_additional_info_prompt' => 'Enter any additional information for joining the virtual meeting, including directly from the app. For example, if the meeting uses Zoom, "Zoom ID: 456 033 8613, Passcode: 1953" would be appropriate.',
    'meeting_editor_screen_meeting_venue_type' => 'Venue Type:',
    'meeting_editor_screen_meeting_venue_type_inperson' => 'In-Person',
    'meeting_editor_screen_meeting_venue_type_virtual' => 'Virtual',
    'meeting_editor_screen_meeting_venue_type_virtualTC' => 'Virtual (temporarily replacing an in-person)',
    'meeting_editor_screen_meeting_venue_type_hybrid' => 'Hybrid (both in-person and virtual)',
    'meeting_editor_screen_meeting_venue_type_validation' => 'You must select a venue type.',
    'meeting_editor_screen_meeting_virtual_info_missing' => 'Virtual or hybrid meetings must have a Virtual Meeting Link, a Phone Meeting Dial-in Number, or Virtual Meeting Additional Information',
    'meeting_editor_screen_meeting_location_warning' => 'Meeting should have a location (at least a city/town and state/province, or a zip/postal code).',
    'meeting_editor_screen_meeting_address_warning' => 'In-person or hybrid meetings should have a street address.',
    'meeting_editor_screen_meeting_url_validation' => 'Virtual Meeting Link is not a valid URL.',
    'meeting_editor_screen_meeting_url_or_phone_warning' => 'Virtual or hybrid meetings should have either a Virtual Meeting Link or a Phone Meeting Dial-in Number',
    'meeting_editor_screen_meeting_additional_warning' => 'Please also fill in Virtual Meeting Additional Information if there is a Virtual Meeting Link.',
    'meeting_editor_screen_in_person_virtual_info_warning' => 'In-person meetings shouldn\'t have any virtual meeting information.',
    'meeting_editor_screen_meeting_virtual_location_info_warning' => 'Virtual meetings shouldn\'t have a location name or address.',
    'meeting_editor_screen_meeting_contact_name_1_label' => 'Contact 1 Name:',
    'meeting_editor_screen_meeting_validation_warning' => 'There are warnings.  Are you sure you want to save anyway?  If not, press \'cancel\' and go to the Location tab to see the warnings in place and address them.',
    'meeting_editor_screen_meeting_validation_failed' => 'Unable to save due to input errors.  Please go to the Location tab to address them, and then retry saving.  Errors: ',
    'meeting_editor_screen_meeting_validation_warnings' => 'Input warnings shown on the Location tab: ',
    'meeting_editor_screen_meeting_contact_email_1_label' => 'Contact 1 Email:',
    'meeting_editor_screen_meeting_contact_phone_1_label' => 'Contact 1 Phone:',
    'meeting_editor_screen_meeting_contact_name_2_label' => 'Contact 2 Name:',
    'meeting_editor_screen_meeting_contact_email_2_label' => 'Contact 2 Email:',
    'meeting_editor_screen_meeting_contact_phone_2_label' => 'Contact 2 Phone:',
    'meeting_editor_screen_meeting_publish_search_prompt' => 'Buscar:',
    'meeting_editor_screen_meeting_publish_search_pub' => 'Solo Reuniones Publicado',
    'meeting_editor_screen_meeting_publish_search_unpub' => 'Solo Reuniones inéditas',
    'meeting_editor_screen_meeting_visibility_advice' => 'Esto nunca se muestra en las búsquedas normales de reuniones.',
    'meeting_editor_screen_meeting_publish_search_all' => 'Todas las reuniones',
    'meeting_editor_screen_meeting_create_button' => 'Crear una nueva reunión',
    'meeting_editor_screen_delete_button' => 'Eliminar esta Reunión',
    'meeting_editor_screen_delete_button_confirm' => '¿Está seguro de que desea eliminar esta reunión?',
    'meeting_editor_screen_cancel_button' => 'Cancelar',
    'logout' => 'Salir',
    'meeting_editor_screen_cancel_confirm' => '¿Está seguro de que desea cancelar la edición de este encuentro y perder todos los cambios?',
    'meeting_lookup_failed' => 'La búsqueda de direcciones falló.',
    'meeting_lookup_failed_not_enough_address_info' => 'No hay suficiente información sobre la dirección válida para realizar una búsqueda.',
    'meeting_create_button_name' => 'Salva esto como una nueva reunión',
    'meeting_saved_as_a_copy' => 'Guardar esta reunión como una copia (Crea una nueva reunión)',
    'meeting_save_buttonName' => 'Guarde los cambios a esta reunión',
    'meeting_editor_tab_bar_basic_tab_text' => 'Básico',
    'meeting_editor_tab_bar_location_tab_text' => 'Ubicación',
    'meeting_editor_tab_bar_format_tab_text' => 'Formato',
    'meeting_editor_tab_bar_other_tab_text' => 'Otro',
    'meeting_editor_tab_bar_history_tab_text' => 'Historia',
    'meeting_editor_result_count_format' => '%d Reuniones Encontrados',
    'meeting_id_label' => 'ID de la reunión:',
    'meeting_editor_default_zoom' => '13',
    'meeting_editor_default_weekday' => '2',
    'meeting_editor_default_start_time' => '20:30:00',
    'login_banner' => 'Reuniones básica Listado de herramientas',
    'login_underbanner' => 'Raíz de la consola de administración del servid',
    'login' => 'Nombre de usuario ID',
    'password' => 'Contraseña',
    'button' => 'Acceder',
    'cookie' => 'Debe habilitar las cookies para poder administrar este servidor.',
    'noscript' => 'No se puede administrar este sitio sin JavaScript.',
    'title' => 'Por favor, inicie sesión para administrar el servidor.',
    'edit_Meeting_object_not_found' => 'ERROR: No se encontró la reunión.',
    'edit_Meeting_object_not_changed' => 'ERROR: La reunión no fue cambiada.',
    'edit_Meeting_auth_failure' => 'No tiene permisos para editar esta reunión.',
    'not_auth_1' => 'NO AUTORIZADO',
    'not_auth_2' => 'You are not authorized to administer this server.',
    'not_auth_3' => 'Había un problema con el nombre de usuario o la contraseña que ha introducido.',
    'email_format_bad' => 'La dirección de correo electrónico que has introducido no se ha formateado correctamente.',
    'history_header_format' => '<div class="bmlt_admin_meeting_history_list_item_line_div history_item_header_div"><span class="bmlt_admin_history_list_header_date_span">%s</span><span class="bmlt_admin_history_list_header_user_span">por %s</span></div>',
    'history_no_history_available_text' => '<h1 class="bmlt_admin_no_history_available_h1">No historia disponible para esta reunión</h1>',
    'service_body_editor_disclosure' => 'Órgano de Administración del Servicio',
    'service_body_change_fader_success_text' => 'El organismo de servicio se cambió con éxito.',
    'service_body_change_fader_fail_text' => 'El cambio del cuerpo de servicio Error.',
    'service_body_editor_screen_sb_id_label' => 'ID:',
    'service_body_editor_screen_sb_name_label' => 'Nombre:',
    'service_body_name_default_prompt_text' => 'Introduzca el nombre de este organismo de servicio',
    'service_body_parent_popup_label' => 'Padres de cuerpo de servicio:',
    'service_body_parent_popup_no_parent_option' => 'Ningún padre (de nivel superior)',
    'service_body_editor_screen_sb_admin_user_label' => 'Administrador Principal:',
    'service_body_editor_screen_sb_admin_description_label' => 'Descripción:',
    'service_body_description_default_prompt_text' => 'Enter A Description of This Service Body',
    'service_body_editor_screen_sb_admin_email_label' => 'Dirección electrónica de contacto:',
    'service_body_email_default_prompt_text' => 'Introduzca una dirección electrónica de contacto para este organismo de servicio',
    'service_body_editor_screen_sb_admin_uri_label' => 'URL del sitio web:',
    'service_body_uri_default_prompt_text' => 'Ingrese una URL del sitio web para este organismo de servicio',
    'service_body_editor_screen_sb_admin_full_editor_label' => 'Editores de reuniones listas completa:',
    'service_body_editor_screen_sb_admin_full_editor_desc' => 'Estos usuarios pueden editar cualquier reuniones dentro este cuerpo de servicio.',
    'service_body_editor_screen_sb_admin_editor_label' => 'Editores de reuniones basico de la lista:',
    'service_body_editor_screen_sb_admin_editor_desc' => 'Estos usuarios pueden editar cualquier Reuniones dentro Este cuerpo de servicio, pero sólo si las reuniones son sin publicar.',
    'service_body_editor_screen_sb_admin_observer_label' => 'Observadores:',
    'service_body_editor_screen_sb_admin_observer_desc' => 'Estos usuarios pueden ver los oculta información (como direcciones de correo electrónico), pero no se puede editar cualquier cosa.',
    'service_body_dirty_confirm_text' => 'Ha realizado cambios a este organismo de servicio. ¿Quieres perder los cambios?',
    'service_body_save_button' => 'Guardar estos cambios al cuerpo de servicio',
    'service_body_create_button' => 'Crear este cuerpo de servicio',
    'service_body_delete_button' => 'Eliminar este cuerpo de servicio',
    'service_body_delete_perm_checkbox' => 'Eliminar este cuerpo de servicio en forma permanente',
    'service_body_delete_button_confirm' => '¿Estas seguro que quieres eliminar este cuerpo de servicio? Make sure that all meetings are either removed or transferred to another service body before performing this function.',
    'service_body_delete_button_confirm_perm' => 'Este cuerpo de servicio será borrada para siempre!',
    'service_body_change_fader_create_success_text' => 'El cuerpo de servicio se creó correctamente',
    'service_body_change_fader_create_fail_text' => 'El Cuerpo de servicios creada no se cumplio',
    'service_body_change_fader_delete_success_text' => 'El cuerpo de servicio se ha eliminado correctamente',
    'service_body_change_fader_delete_fail_text' => 'No se cumplio eliminar el cuerpo de servicio',
    'service_body_change_fader_fail_no_data_text' => 'El cambio del cuerpo de servicio Error, porque no había aportado datos',
    'service_body_change_fader_fail_cant_find_sb_text' => 'El cambio del cuerpo de servicio Error, porque el cuerpo de servicio no se encontró',
    'service_body_change_fader_fail_cant_update_text' => 'The Service Body Change Failed, Because The Service Body Was Not Updated',
    'service_body_change_fader_fail_bad_hierarchy' => 'El cambio del cuerpo de servicio Error, ya que el seleccionado propietario de cuerpo de servicio está bajo este cuerpo de servicio, y no puede ser usad',
    'service_body_cancel_button' => 'Restaurar a original',
    'service_body_editor_type_label' => 'Tipo de cuerpo servicio:',
    'service_body_editor_type_c_comdef_service_body__GRP__' => 'Grupo',
    'service_body_editor_type_c_comdef_service_body__COP__' => 'Co-Op',
    'service_body_editor_type_c_comdef_service_body__ASC__' => 'Comité de Servicio de Área',
    'service_body_editor_type_c_comdef_service_body__RSC__' => 'Conferencia de Servicio Regional',
    'service_body_editor_type_c_comdef_service_body__WSC__' => 'World Service Conference',
    'service_body_editor_type_c_comdef_service_body__MAS__' => 'Metro Area',
    'service_body_editor_type_c_comdef_service_body__ZFM__' => 'Foro Zonal',
    'service_body_editor_type_c_comdef_service_body__GSU__' => 'Group Service Unit',
    'service_body_editor_type_c_comdef_service_body__LSU__' => 'Local Service Unit',
    'service_body_editor_screen_helpline_label' => 'Helpline:',
    'service_body_editor_screen_helpline_prompt' => 'Enter The Helpline Telephone Number',
    'service_body_editor_uri_naws_format_text' => 'Obtener las reuniones de este órgano de servicio como un archivo NAWS-Compatible',
    'edit_Meeting_meeting_id' => 'ID de la reunión:',
    'service_body_editor_create_new_sb_option' => 'Crear un cuerpo nuevo de servicio',
    'service_body_editor_screen_world_cc_label' => 'Código Mundial de Comité:',
    'service_body_editor_screen_world_cc_prompt' => 'Introduzca un código de Comité Mundial',
    'user_editor_disclosure' => 'Administración de usuarios',
    'user_editor_create_new_user_option' => 'Crear un nuevo usuario',
    'user_editor_screen_sb_id_label' => 'ID:',
    'user_editor_account_login_label' => 'Registro de usuarios:',
    'user_editor_login_default_text' => 'Introduzca el nombre de usuario',
    'user_editor_account_type_label' => 'User Is A:',
    'user_editor_user_owner_label' => 'Controlado Por: ',
    'user_editor_account_type_1' => 'Administrador de Servicio',
    'user_editor_account_type_2' => 'Administrador de cuerpo de servicior',
    'user_editor_account_type_3' => 'Editor cuerpo de servicio',
    'user_editor_account_type_5' => 'Observadores de cuerpo de servicio',
    'user_editor_account_type_4' => 'Usario discapacitado',
    'user_editor_account_name_label' => 'Nombre de usuario:',
    'user_editor_name_default_text' => 'Introduzca el nombre de usuario',
    'user_editor_account_description_label' => 'Descripción:',
    'user_editor_description_default_text' => 'Introduzca la descripción del usuario',
    'user_editor_account_email_label' => 'Correo electrónica:',
    'user_editor_email_default_text' => 'Introduzca el user correo electrónico',
    'user_change_fader_success_text' => 'El usuario se cambió con éxito',
    'user_change_fader_fail_text' => 'El cambio de usuario error',
    'user_change_fader_create_success_text' => 'The User Was Successfully Created',
    'user_change_fader_create_fail_text' => 'El usuario crear error',
    'user_change_fader_create_fail_already_exists' => 'Un inicio de sesión del usuario que está intentando crear ya existe.',
    'user_change_fader_delete_success_text' => 'El usuario se ha eliminado correctamente',
    'user_change_fader_delete_fail_text' => 'El usuario borrar error',
    'user_save_button' => 'Guarde los cambios para este usuario',
    'user_create_button' => 'Crear este nuevo usuario',
    'user_cancel_button' => 'Restaurar a original',
    'user_delete_button' => 'Elimine este usuario',
    'user_delete_perm_checkbox' => 'Elimine este usuario forma permanente',
    'user_password_label' => 'Cambiar contraseña para:',
    'user_new_password_label' => 'Establecer contraseña a:',
    'user_password_default_text' => 'Deja eso, a menos que quiera cambiar la contraseña',
    'user_new_password_default_text' => 'Debe introducir una contraseña para un usuario nuevo',
    'user_dirty_confirm_text' => 'Ha realizado cambios a este usuario. ¿Quieres perder los cambios?',
    'user_delete_button_confirm' => '¿Estas seguro que quieres eliminar este usuario?',
    'user_delete_button_confirm_perm' => 'This user will be deleted permanently!',
    'user_create_password_alert_text' => 'Los nuevos usuarios deben tener una contraseña. Usted no ha suministrado una contraseña para este usuario.',
    'user_change_fader_fail_no_data_text' => 'El Cambiar usuario falló, porque no había aportado datos',
    'user_change_fader_fail_cant_find_sb_text' => 'El Cambiar usuario falló, porque el usuario no se encontró',
    'user_change_fader_fail_cant_update_text' => 'El Cambiar usuario falló, porque el usuario no se actualizaba',
    'format_editor_disclosure' => 'Formato de administración',
    'format_change_fader_change_success_text' => 'El formato fue creadó correctamente',
    'format_change_fader_change_fail_text' => 'Error en cambio de formato',
    'format_change_fader_create_success_text' => 'The Format Was Successfully Created',
    'format_change_fader_create_fail_text' => 'Error en crear formato',
    'format_change_fader_delete_success_text' => 'El formato se ha eliminado correctamente',
    'format_change_fader_delete_fail_text' => 'El formato eliminado con error',
    'format_change_fader_fail_no_data_text' => 'El cambio de formato con error, porque no había aportado datos',
    'format_change_fader_fail_cant_find_sb_text' => 'El cambio de formato con error, porque el formato no se encontró',
    'format_change_fader_fail_cant_update_text' => 'El cambio de formato con error, porque el formato no se actualizaba',
    'format_editor_name_default_text' => 'Escriba una descripción muy corta',
    'format_editor_description_default_text' => 'Escriba una descripción más detallada',
    'format_editor_create_format_button_text' => 'Crear nuevo formato',
    'format_editor_cancel_create_format_button_text' => 'Cancelar',
    'format_editor_create_this_format_button_text' => 'Crear este formato',
    'format_editor_change_format_button_text' => 'Cambiar este formato',
    'format_editor_delete_format_button_text' => 'Eliminar este formato',
    'format_editor_reset_format_button_text' => 'Restaurar al original',
    'need_refresh_message_fader_text' => 'Usted debe cargar esta página antes de utilizar esta sección',
    'need_refresh_message_alert_text' => 'Because you have made changes in the Server Administration, Service Body Administration, User Administration, or Format Administration, the information displayed in this section may no longer be accurate, so the page needs to be refreshed. The easiest way to do this, is to Sign Out, then Log In again.',
    'format_editor_delete_button_confirm' => '¿Estas seguro que quieres eliminar este formato?',
    'format_editor_delete_button_confirm_perm' => 'Este formato se eliminará para siempre!',
    'format_editor_missing_key' => 'This format should have an entry for every language (at least a key).',   // TODO: translate
    'format_editor_reserved_key' => 'This key is reserved for a venue type format - please use something different.',       // TODO: translate
    'min_password_length_string' => 'El contraseña es demasiado corta! Debe ser al menos %d caracteres!',
    'AJAX_Auth_Failure' => 'Error en la autorización para esta operación. Puede haber un problema con la configuración del servidor.',
    'Maps_API_Key_Warning' => 'There is a problem with the Google Maps API Key.',
    'Observer_Link_Text' => 'Meeting Browser',
    'Data_Transfer_Link_Text' => 'Import Meeting Data (WARNING: Replaces Current Data!)',
    'MapsURL' => 'https://maps.google.com/maps?q=##LAT##,##LONG##+(##NAME##)&amp;ll=##LAT##,##LONG##',
    'hidden_value' => 'No se puede mostrar datos-no autorizada',
    'Value_Prompts' => array(
        'id_bigint' => 'ID de reunion',
        'worldid_mixed' => 'World Services ID',
        'service_body' => 'Cuerpo de servicio',
        'service_bodies' => 'Cuerpos de servicio',
        'weekdays' => 'Días de la semana',
        'weekday' => 'Reunión recolecta cada',
        'start_time' => 'Comienza la reunión',
        'duration_time' => 'Reunión Dura',
        'location' => 'Ubicación',
        'duration_time_hour' => 'Hora',
        'duration_time_hours' => 'Horas',
        'duration_time_minute' => 'Minuto',
        'duration_time_minutes' => 'Minutos',
        'lang_enum' => 'Idioma',
        'formats' => 'Formatos',
        'distance' => 'Distancia del Centro',
        'generic' => 'Reunion de NA',
        'close_title' => 'Cierre esta ventana detalle de reuniones',
        'close_text' => 'Cierar ventana',
        'map_alt' => 'Mapa a reunión',
        'map' => 'Sigue este enlace para ver un mapa',
        'title_checkbox_unpub_meeting' => 'Esta reunión es inédito. No puede ser visto por búsquedas regulares.',
        'title_checkbox_copy_meeting' => 'Esta reunión es un duplicado de otra reunión. También es inédito. No puede ser visto por búsquedas regulares.'
    ),
    'world_format_codes_prompt' => 'NAWS Format:',
    'world_format_codes' => array(
        '' => 'Ninguno',
        'OPEN' => 'Abierto',
        'CLOSED' => 'Cerrado',
        'WCHR' => 'Accesible silla de ruedas',
        'BEG' => 'Principiantes',
        'BT' => 'Texto Basico',
        'CAN' => 'Las Velas',
        'CPT' => '12 Conceptos',
        'CW' => 'Niños son bienvenidos',
        'DISC' => 'Discusión/Participación',
        'GL' => 'Gay/Lesbiana',
        'IP' => 'Estudio IP',
        'IW' => 'Estudio funciona',
        'JFT' => 'Estudio Solo Por Hoy',
        'LC' => 'Vivir Limpios',
        'LIT' => 'Estudio de Literatura',
        'M' => 'Hombres',
        'MED' => 'Meditación',
        'NS' => 'Non-Smoking',
        'QA' => 'Preguntas y Respuestas',
        'RA' => 'Acceso Restringido',
        'S-D' => 'Speaker/Discussion', // TODO translate
        'SMOK' => 'Fumar',
        'SPK' => 'Orador',
        'STEP' => 'Pasos',
        'SWG' => 'Estudio de Guía de Pasos',
        'TOP' => 'Topico',
        'TRAD' => 'Tradicion',
        'VAR' => 'Formato Varía',
        'W' => 'Mujeres',
        'Y' => 'Jovenes',
        'LANG' => 'Idioma alternativo',
        'GP' => 'Guiding Principles', // TODO translate
        'NC' => 'No Children', // TODO translate
        'CH' => 'Closed Holidays', // TODO translate
        'VM' => 'Virtual', // TODO translate
        'HYBR' => 'Virtual and In-Person', // TODO translate
        'TC' => 'Temporarily Closed Facility', // TODO translate
        'SPAD' => 'Spiritual Principle a Day', // TODO translate
    ),
    'format_type_prompt' => 'Format Type:',
    'format_type_codes' => array(
        '' => 'None',
        'FC1' => 'Meeting Format (Speaker, Book Study, etc.)',
        'FC2' => 'Location Code (Wheelchair Accessible, Limited Parking, etc.)',
        'FC3' => 'Common Needs and Restrictions (Mens Meeting, LGTBQ, No Children, etc.)',
        'O' => 'Attendance by non-addicts (Open, Closed)',
        'LANG' => 'Language',
        'ALERT' => 'Format should be especially prominent (Clean requirement, etc.)',
    ),
    'cookie_monster' => 'Este sitio utiliza cookies para almacenar su idioma preferido.',
    'main_prompts' => array(
        'id_bigint' => 'ID',
        'worldid_mixed' => 'World ID',
        'shared_group_id_bigint' => 'Unused',
        'service_body_bigint' => 'Service Body ID',
        'weekday_tinyint' => 'Weekday',
        'venue_type' => 'Venue Type',
        'start_time' => 'Start Time',
        'duration_time' => 'Duration',
        'time_zone' => 'Time Zone',
        'formats' => 'Formats',
        'lang_enum' => 'Language',
        'longitude' => 'Longitude',
        'latitude' => 'Latitude',
        'published' => 'Published',
        'email_contact' => 'Email Contact',
    ),
    'check_all' => 'Check All',
    'uncheck_all' => 'Uncheck All',
    'automatically_calculated_on_save' => 'Automatically calculated on save.'
);

$email_contact_strings = array(
    'meeting_contact_form_subject_format' => "[Contactos de Listado de Reuniones] %s",
    'meeting_contact_message_format' => "%s\n--\nThis message concerns the meeting named \"%s\", which meets at %s, on %s.\nBrowser Link: %s\nEdit Link: %s\nIt was sent directly from the meeting list web server, and the sender is not aware of your email address.\nPlease be aware that replying will expose your email address.\nIf you use \"Reply All\", and there are multiple email recipients, you may expose other people's email addresses.\nPlease respect people's privacy and anonymity; including the original sender of this message."
);

$change_type_strings = array(
    '__THE_MEETING_WAS_CHANGED__' => 'La reunion fue cambiada.',
    '__THE_MEETING_WAS_CREATED__' => 'La reunion fue creada.',
    '__THE_MEETING_WAS_DELETED__' => 'La reunion fue eliminada.',
    '__THE_MEETING_WAS_ROLLED_BACK__' => 'La reunión se ha retrotraído a una versión anterior.',

    '__THE_FORMAT_WAS_CHANGED__' => 'El formato ha cambiado.',
    '__THE_FORMAT_WAS_CREATED__' => 'El formato fue creado.',
    '__THE_FORMAT_WAS_DELETED__' => 'Formato fue eliminad.',
    '__THE_FORMAT_WAS_ROLLED_BACK__' => 'El formato se ha retrotraído a una versión anterior.',

    '__THE_SERVICE_BODY_WAS_CHANGED__' => 'El cuerpo de servicio se ha cambiado.',
    '__THE_SERVICE_BODY_WAS_CREATED__' => 'El cuerpo de servicio fue creado.',
    '__THE_SERVICE_BODY_WAS_DELETED__' => 'El cuerpo de servicio fue eliminado.',
    '__THE_SERVICE_BODY_WAS_ROLLED_BACK__' => 'El cuerpo de servicio se ha retrotraído a una versión anterior.',

    '__THE_USER_WAS_CHANGED__' => 'El usuario ha cambiado.',
    '__THE_USER_WAS_CREATED__' => 'Se creó el usuario.',
    '__THE_USER_WAS_DELETED__' => 'El usuario se ha eliminado.',
    '__THE_USER_WAS_ROLLED_BACK__' => 'El usuario se ha retrotraído a una versión anterior.',

    '__BY__' => 'por',
    '__FOR__' => 'para'
);

$detailed_change_strings = array(
    'was_changed_from' => 'fue cambiado de',
    'to' => 'a',
    'was_changed' => 'cambiado',
    'was_added_as' => 'fue introducido como',
    'was_deleted' => 'fue elimanado',
    'was_published' => 'La reunión se publicó',
    'was_unpublished' => 'El reunión fue inédito',
    'formats_prompt' => 'Formato de reunion',
    'duration_time' => 'La duración de reunión',
    'start_time' => 'Hora de inicio de la reunion',
    'longitude' => 'La longitud de reunión',
    'latitude' => 'El latitud de reunión',
    'sb_prompt' => 'La reunión cambió su cuerpo de servicio de',
    'id_bigint' => 'ID de la reunion',
    'lang_enum' => 'Idioma de la reunion',
    'worldid_mixed' => 'El ID de grupo compartida',  // TODO: translate The World Committee Code
    'weekday_tinyint' => 'El día de la semana en que se reúne la reunión',
    'non_existent_service_body' => 'Cuerpo de Servicio ya no existe',
);

defined('_END_CHANGE_REPORT') or define('_END_CHANGE_REPORT', '.');
