import LocalizedStrings from 'localized-strings';

import { writable } from 'svelte/store';
import type { Subscriber, Unsubscriber } from 'svelte/store';

/*eslint sort-keys: ["error", "asc", {caseSensitive: false}]*/
const strings = new (LocalizedStrings as any)({
  de: {
    accountSettingsTitle: 'Account Einstellungen',
    accountTitle: 'Account',
    accountTypeTitle: 'AccountTyp',
    addFormat: 'Format hinzufügen',
    addMeeting: 'Meeting hinzufügen',
    addServiceBody: 'Service-Body hinzufügen',
    addUser: 'Benutzer hinzufügen',
    administratorTitle: 'Administrator*in',
    adminTitle: 'Admin',
    anteMeridiem: 'AM',
    applyChangesTitle: 'Änderung anwenden',
    boroughTitle: 'Stadtviertel', // TODO: check this - English is Borough/City Subsection
    busLinesTitle: 'Buslinien',
    by: 'von',
    cancel: 'Stornieren',
    chooseStartTime: 'Startzeit wählen',
    cityTownTitle: 'Stadt',
    clearFormTitle: 'Formular löschen',
    closeWithoutSaving: 'Schließen ohne zu speichern',
    commentsTitle: 'Kommentare',
    confirmDeleteFormat: 'Bist du sicher, dass du dieses Format löschen möchten?',
    confirmDeleteMeeting: 'Bist du sicher, dass du dieses Meeting löschen möchten?',
    confirmDeleteServiceBody: 'Bist du sicher, dass du diesen Service-Body löschen möchten?',
    confirmDeleteUser: 'Bist du sicher, dass du diesen Benutzer löschen möchten?',
    confirmYesImSure: 'Ja, ich bin sicher.',
    contact1EmailTitle: 'Kontakt 1 E-Mail',
    contact1NameTitle: 'Kontakt 1 Name',
    contact1PhoneTitle: 'Kontakt 1 Telefon',
    contact2EmailTitle: 'Kontakt 2 E-Mail',
    contact2NameTitle: 'Kontakt 2 Name',
    contact2PhoneTitle: 'Kontakt 2 Telefon',
    countySubProvinceTitle: 'Bezirk', //  // TODO: check this - English is County/Sub-Province
    dashboardTitle: 'Dashboard',
    day: 'Tag',
    daysOfWeek: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'],
    dayTitle: 'Wochentag',
    deactivatedTitle: 'Deaktiviert',
    deactivatedUserTitle: 'Deaktivierter Benutzer',
    delete: 'löschen',
    deleteFormat: 'Format löschen',
    deleteMeeting: 'Meeting löschen',
    deleteServiceBody: 'Service-Body löschen',
    deleteUser: 'Lösche diesen Benutzer',
    descriptionTitle: 'Beschreibung',
    durationTitle: 'Dauer',
    editFormat: 'Format bearbeiten',
    editUser: 'Benutzer bearbeiten',
    emailTitle: 'E-Mail-Adresse',
    extraInfoTitle: 'Weitere Informationen',
    filter: 'Filter',
    formatDeleteConflictError: 'Fehler: Das Format konnte nicht gelöscht werden, da es noch mit Meetings verknüpft ist.',
    formatId: 'Format-ID',
    formatsTitle: 'Formate',
    formatTranslationIsRequired: 'Für reservierte Formate ist eine Übersetzung für alle Sprachen erforderlich',
    formatTypeCodes: [
      { name: 'Teilnahme von Nichtsüchtigen (offen, geschlossen)', value: 'OPEN_OR_CLOSED' },
      { name: 'Allgemeine Bedürfnisse und Einschränkungen (Männermeeting, LGBTQ, keine Kinder usw.)', value: 'COMMON_NEEDS_OR_RESTRICTION' },
      { name: 'Das Format sollte besonders hervorgehoben werden (Cleanzeitanforderung usw.).', value: 'ALERT' },
      { name: 'Sprache', value: 'LANGUAGE' },
      { name: 'Standortcode (Rollstuhlgerecht, begrenzte Parkmöglichkeiten usw.)', value: 'LOCATION' },
      { name: 'Meetingformat (Sprecher, Lesen aus NA-Literatur usw.)', value: 'MEETING_FORMAT' },
      { name: 'Keine', value: '' }
    ],
    formatTypeTitle: 'Formattyp',
    formatValidationError: 'Fehler: Dieses Format ist geschützt und kann nicht gelöscht werden.',
    helplineTitle: 'Helpline',
    homeTitle: 'Startseite',
    hoursTitle: 'Std.',
    idTitle: 'ID',
    invalidUsernameOrPassword: 'Ungültiger Benutzername oder Passwort.',
    keyIsRequired: 'Schlüssel ist erforderlich',
    keyIsReserved: 'Schlüssel ist reserviert -- bitte verwende etwas anderes',
    keyTitle: 'Schlüssel',
    languageSelectTitle: 'Sprache auswählen',
    latitudeTitle: 'Breitengrad',
    loading: 'geladen ...',
    locationMapTitle: 'Lageplan',
    locationStreetErrorMessage: 'Für Hybrid- oder präsenz-Meetings muss eine Straßenadresse angegeben werden.',
    locationTextTitle: 'Standorttext',
    loginTitle: 'Anmeldung',
    loginVerb: 'Anmelden',
    logout: 'Abmelden',
    longitudeTitle: 'Längengrad',
    meetingErrorsSomewhere: 'Seiten mit einem oder mehreren Fehlern:',
    meetingIsPublishedTitle: 'Meeting ist veröffentlicht',
    meetingListEditorsTitle: 'Meetingsliste Editors', // TODO: check translation
    meetingsPerPage: 'Meetings per page', // TODO: Translate
    meetingsTitle: 'Meetings',
    meetingUnpublishedNote:
      'Hinweis: Das Aufheben der Veröffentlichung eines Meetings bedeutet, dass es vorübergehend geschlossen wurde. Wenn dieses Meeting dauerhaft geschlossen wurde, lösch es bitte.',
    minutesTitle: 'Minuten',
    nameTitle: 'Name',
    nationTitle: 'Nation',
    nawsFormats: [
      { name: '12 Konzepte', value: 'CPT' },
      { name: 'Fremdsprache', value: 'LANG' },
      { name: 'Basic Text', value: 'BT' },
      { name: 'Neuankömmling/Newcomer', value: 'BEG' },
      { name: 'Kerzenlicht', value: 'CAN' },
      { name: 'Kinder willkommen', value: 'CW' },
      { name: 'Geschlossen', value: 'CLOSED' },
      { name: 'Closed Holidays', value: 'CH' }, // TODO translate
      { name: 'Diskussion/Teilen', value: 'DISC' },
      { name: 'Format variatiiert', value: 'VAR' },
      { name: 'Schwul/Lesbisch', value: 'GL' },
      { name: 'Guiding Principles', value: 'GP' },
      { name: 'Thema Faltblätter', value: 'IP' },
      { name: 'Es funktioniert', value: 'IW' },
      { name: 'Nur für Heute', value: 'JFT' },
      { name: 'Literaturmeeting', value: 'LIT' },
      { name: 'Thema Clean Leben', value: 'LC' },
      { name: 'Meditation', value: 'MED' },
      { name: 'Männer', value: 'M' },
      { name: 'Kinder nicht erlaubt', value: 'NC' },
      { name: 'Rauchen verboten', value: 'NS' },
      { name: 'Keine', value: '' },
      { name: 'Offen', value: 'OPEN' },
      { name: 'Frage & Antwort', value: 'QA' },
      { name: 'Eingeschränkter Zutritt', value: 'RA' },
      { name: 'Raucher', value: 'SMOK' },
      { name: 'Sprecher', value: 'SPK' },
      { name: 'Sprecher / Diskussion', value: 'S-D' },
      { name: 'Ein spirituelles Prinzip pro Tag', value: 'SPAD' },
      { name: 'Schritte', value: 'STEP' },
      { name: 'Schritteleitfaden', value: 'SWG' },
      { name: 'Temporarily Closed Facility', value: 'TC' }, // TODO translate
      { name: 'Themenmeeting', value: 'TOP' },
      { name: 'Traditionenmeeting', value: 'TRAD' },
      { name: 'Virtual', value: 'VM' }, // TODO translate
      { name: 'Virtual and In-Person', value: 'HYBR' }, // TODO translate
      { name: 'Rollstuhlzugang', value: 'WCHR' },
      { name: 'Frauen', value: 'W' },
      { name: 'Junge Menschen', value: 'Y' }
    ],
    nawsFormatTitle: 'NAWS Format',
    neighborhoodTitle: 'Nachbarschaft',
    noFormatTranslationsError: 'Es ist mindestens eine Übersetzung erforderlich.',
    none: '- Keine -',
    noServiceBodiesTitle: 'Es wurden keine Service-Bodies gefunden, die dieser Benutzer bearbeiten kann',
    noTranslationAvailable: 'keine deutsche Version verfügbar',
    noUsersTitle: 'Es wurden keine anderen Benutzer gefunden, die dieser Benutzer bearbeiten kann',
    noWhitespaceInKey: 'Leerzeichen im Schlüssel sind nicht erlaubt',
    observerTitle: 'Service-Body Beobachter',
    ownedByTitle: 'Gehört',
    paginationOf: 'von',
    paginationShowing: 'Zeigt',
    parentIdTitle: 'Service-Body Eltern', // TODO: check translation
    passwordTitle: 'Passwort',
    phoneMeetingTitle: 'Telefonnummer für Telefonmeeting',
    postMeridiem: 'PM',
    published: 'Veröffentlicht',
    search: 'Suchen',
    searchByDay: 'Suche nach Tag',
    searchByName: 'Suche nach Name',
    searchByServiceBody: 'Suche nach Service-Body',
    searchMeetings: 'Suche Meetings...',
    selectAllDays: 'Alle Tage wählen',
    selectAllServiceBodies: 'Select All Service Bodies', // TODO: Translate
    serverAdministratorTitle: 'Hauptserveradministrator*in',
    serverTitle: 'BMLT-Server',
    serviceBodiesNoParent: 'Kein übergeordnetes Element (oberste Ebene)',
    serviceBodiesTitle: 'Service-Bodies',
    serviceBodiesWithEditableMeetings: 'Dieser Benutzer kann Meetings in diesen Service-Bodies bearbeiten:',
    serviceBodyAdminTitle: 'Service-Body Administrator*in',
    serviceBodyDeleteConflictError: 'Fehler: Der Service-Body konnte nicht gelöscht werden, da er noch mit Meetings verknüpft ist oder anderen Service-Bodies übergeordnet ist.',
    serviceBodyTitle: 'Service-Body',
    serviceBodyTypeTitle: 'Service-Body-Typ',
    showAllTranslations: 'Alle Übersetzungen anzeigen',
    startTimeTitle: 'Startzeit',
    stateTitle: 'Staat/Provinz',
    streetTitle: 'Straße',
    tabsBasic: 'Basic',
    tabsChanges: 'Änderungen',
    tabsLocation: 'Standort',
    tabsOther: 'Andere',
    time: 'Zeit',
    timeAfternoon: 'Nachmittag',
    timeEvening: 'Abend',
    timeMorning: 'Morgen',
    timeZoneSelectPlaceholder: 'Option auswählen (oder leer lassen, um die automatische Erkennung anhand des Standorts zu aktivieren)',
    timeZoneTitle: 'Zeitzone',
    trainLinesTitle: 'Zuglinien',
    unpublished: 'Unveröffentlicht',
    unselectAllDays: 'Auswahl für „Alle Tage“ aufheben',
    unselectAllServiceBodies: 'Unselect All Service Bodies', // TODO: Translate
    userDeleteConflictError: 'Fehler: Der Benutzer konnte nicht gelöscht werden, da er noch mindestens einem Service-Body zugeordnet ist oder das übergeordnete Element eines anderen Benutzers ist.',
    userIsDeactivated: 'Benutzer ist deaktiviert.',
    usernameTitle: 'Benutzername',
    usersTitle: 'Benutzer',
    userTitle: 'Benutzer',
    userTypeTitle: 'Benutzertyp',
    venueTypeTitle: 'Art des Veranstaltungsortes',
    virtualMeetingAdditionalInfoTitle: 'Online-Meetings Weitere Informationen',
    virtualMeetingTitle: 'Online-Meeting URL',
    websiteUrlTitle: 'Website-URL',
    welcome: 'Willkommen',
    worldIdTitle: 'World-Committee ID',
    youHaveUnsavedChanges: 'Du hast nicht gespeicherte Änderungen. Möchtest du wirklich schließen?',
    zipCodeTitle: 'Postleitzahl'
  },
  en: {
    accountSettingsTitle: 'Account Settings',
    accountTitle: 'Account',
    accountTypeTitle: 'Account Type',
    addFormat: 'Add Format',
    addMeeting: 'Add Meeting',
    addServiceBody: 'Add Service Body',
    addUser: 'Add User',
    administratorTitle: 'Administrator',
    adminTitle: 'Admin',
    anteMeridiem: 'AM',
    applyChangesTitle: 'Apply Changes',
    boroughTitle: 'Borough/City Subsection',
    busLinesTitle: 'Bus Lines',
    by: 'by',
    cancel: 'Cancel',
    chooseStartTime: 'Choose start time',
    cityTownTitle: 'City/Town',
    clearFormTitle: 'Clear Form',
    closeWithoutSaving: 'Close without saving',
    commentsTitle: 'Comments',
    confirmDeleteFormat: 'Are you sure you want to delete this format?',
    confirmDeleteMeeting: 'Are you sure you want to delete this meeting?',
    confirmDeleteServiceBody: 'Are you sure you want to delete this service body?',
    confirmDeleteUser: 'Are you sure you want to delete this user?',
    confirmYesImSure: "Yes, I'm sure.",
    contact1EmailTitle: 'Contact 1 Email',
    contact1NameTitle: 'Contact 1 Name',
    contact1PhoneTitle: 'Contact 1 Phone',
    contact2EmailTitle: 'Contact 2 Email',
    contact2NameTitle: 'Contact 2 Name',
    contact2PhoneTitle: 'Contact 2 Phone',
    countySubProvinceTitle: 'County/Sub-Province',
    dashboardTitle: 'Dashboard',
    day: 'Day',
    daysOfWeek: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    dayTitle: 'Weekday',
    deactivatedTitle: 'Deactivated',
    deactivatedUserTitle: 'Deactivated User',
    delete: 'Delete',
    deleteFormat: 'Delete Format',
    deleteMeeting: 'Delete Meeting',
    deleteServiceBody: 'Delete Service Body',
    deleteUser: 'Delete User',
    descriptionTitle: 'Description',
    durationTitle: 'Duration',
    editFormat: 'Edit Format',
    editUser: 'Edit User',
    emailTitle: 'Email',
    extraInfoTitle: 'Extra Info',
    filter: 'Filter',
    formatDeleteConflictError: 'Error: The format could not be deleted because it is still associated with meetings.',
    formatId: 'Format ID',
    formatsTitle: 'Formats',
    formatTranslationIsRequired: 'a translation is required for all languages for reserved formats',
    formatTypeCodes: [
      { name: 'Attendance by non-addicts (Open, Closed)', value: 'OPEN_OR_CLOSED' },
      { name: 'Common Needs and Restrictions (Mens Meeting, LGTBQ, No Children, etc.)', value: 'COMMON_NEEDS_OR_RESTRICTION' },
      { name: 'Format should be especially prominent (Clean requirement, etc.)', value: 'ALERT' },
      { name: 'Language', value: 'LANGUAGE' },
      { name: 'Location Code (Wheelchair Accessible, Limited Parking, etc.)', value: 'LOCATION' },
      { name: 'Meeting Format (Speaker, Book Study, etc.)', value: 'MEETING_FORMAT' },
      { name: 'None', value: '' }
    ],
    formatTypeTitle: 'Format Type',
    formatValidationError: 'Error: This format is protected and cannot be deleted.',
    helplineTitle: 'Helpline',
    homeTitle: 'Home',
    hoursTitle: 'Hours',
    idTitle: 'ID',
    invalidUsernameOrPassword: 'Invalid username or password.',
    keyIsRequired: 'key is required',
    keyIsReserved: 'key is reserved  -- please use something else',
    keyTitle: 'Key',
    languageSelectTitle: 'Select Language',
    latitudeTitle: 'Latitude',
    loading: 'loading ...',
    locationMapTitle: 'Location Map', // TOFIX: translate
    locationStreetErrorMessage: 'Hybrid or In-person meetings must have a street address.',
    locationTextTitle: 'Location Text',
    loginTitle: 'Login',
    loginVerb: 'Log In',
    logout: 'Logout',
    longitudeTitle: 'Longitude',
    meetingErrorsSomewhere: 'Tabs with one or more errors:',
    meetingIsPublishedTitle: 'Meeting is Published',
    meetingListEditorsTitle: 'Meeting List Editors',
    meetingsPerPage: 'Meetings per page',
    meetingsTitle: 'Meetings',
    meetingUnpublishedNote: 'Note: Unpublishing a meeting indicates a temporary closure. If this meeting has closed permanently, please delete it.',
    minutesTitle: 'Minutes',
    nameTitle: 'Name',
    nationTitle: 'Nation',
    nawsFormats: [
      { name: '12 Concepts', value: 'CPT' },
      { name: 'Alternate Language', value: 'LANG' },
      { name: 'Basic Text', value: 'BT' },
      { name: 'Beginner/Newcomer', value: 'BEG' },
      { name: 'Candlelight', value: 'CAN' },
      { name: 'Children Welcome', value: 'CW' },
      { name: 'Closed', value: 'CLOSED' },
      { name: 'Closed Holidays', value: 'CH' },
      { name: 'Discussion/Participation', value: 'DISC' },
      { name: 'Format Varies', value: 'VAR' },
      { name: 'Gay/Lesbian', value: 'GL' },
      { name: 'Guiding Principles', value: 'GP' },
      { name: 'IP Study', value: 'IP' },
      { name: 'It Works Study', value: 'IW' },
      { name: 'Just For Today Study', value: 'JFT' },
      { name: 'Literature Study', value: 'LIT' },
      { name: 'Living Clean', value: 'LC' },
      { name: 'Meditation', value: 'MED' },
      { name: 'Men', value: 'M' },
      { name: 'No Children', value: 'NC' },
      { name: 'Non-Smoking', value: 'NS' },
      { name: 'None', value: '' },
      { name: 'Open', value: 'OPEN' },
      { name: 'Questions & Answers', value: 'QA' },
      { name: 'Restricted Access', value: 'RA' },
      { name: 'Smoking', value: 'SMOK' },
      { name: 'Speaker', value: 'SPK' },
      { name: 'Speaker/Discussion', value: 'S-D' },
      { name: 'Spiritual Principle a Day', value: 'SPAD' },
      { name: 'Step', value: 'STEP' },
      { name: 'Step Working Guide Study', value: 'SWG' },
      { name: 'Temporarily Closed Facility', value: 'TC' },
      { name: 'Topic', value: 'TOP' },
      { name: 'Tradition', value: 'TRAD' },
      { name: 'Virtual', value: 'VM' },
      { name: 'Virtual and In-Person', value: 'HYBR' },
      { name: 'Wheelchair-Accessible', value: 'WCHR' },
      { name: 'Women', value: 'W' },
      { name: 'Young People', value: 'Y' }
    ],
    nawsFormatTitle: 'NAWS Format',
    neighborhoodTitle: 'Neighborhood',
    noFormatTranslationsError: 'At least one translation is required.',
    none: '- None -',
    noServiceBodiesTitle: 'No service bodies found that this user can edit',
    noTranslationAvailable: 'no English version available',
    noUsersTitle: 'No other users found that this user can edit',
    noWhitespaceInKey: 'Whitespace not allowed in key',
    observerTitle: 'Service Body Observer',
    ownedByTitle: 'Owned By',
    paginationOf: 'of',
    paginationShowing: 'Showing',
    parentIdTitle: 'Service Body Parent',
    passwordTitle: 'Password',
    phoneMeetingTitle: 'Phone Meeting Dial-in Number',
    postMeridiem: 'PM',
    published: 'Published',
    search: 'Search',
    searchByDay: 'Search by day',
    searchByName: 'Search by name',
    searchByServiceBody: 'Search by Service Body',
    searchMeetings: 'Search meetings...',
    selectAllDays: 'Select All Days',
    selectAllServiceBodies: 'Select All Service Bodies',
    serverAdministratorTitle: 'Main Server Administrator',
    serverTitle: 'BMLT Server',
    serviceBodiesNoParent: 'No Parent (Top-Level)',
    serviceBodiesTitle: 'Service Bodies',
    serviceBodiesWithEditableMeetings: 'This user can edit meetings in these service bodies:',
    serviceBodyAdminTitle: 'Service Body Administrator',
    serviceBodyDeleteConflictError: 'Error: The service body could not be deleted because it is still associated with meetings or is a parent of other service bodies.',
    serviceBodyTitle: 'Service Body',
    serviceBodyTypeTitle: 'Service Body Type',
    showAllTranslations: 'Show all translations',
    startTimeTitle: 'Start Time',
    stateTitle: 'State/Province',
    streetTitle: 'Street',
    tabsBasic: 'Basic',
    tabsChanges: 'Changes',
    tabsLocation: 'Location',
    tabsOther: 'Other',
    time: 'Time',
    timeAfternoon: 'Afternoon',
    timeEvening: 'Evening',
    timeMorning: 'Morning',
    timeZoneSelectPlaceholder: 'Choose option (or leave blank to auto-detect from location)',
    timeZoneTitle: 'Time Zone',
    trainLinesTitle: 'Train Lines',
    unpublished: 'Unpublished',
    unselectAllDays: 'Unselect All Days',
    unselectAllServiceBodies: 'Unselect All Service Bodies',
    userDeleteConflictError: 'Error: The user could not be deleted because it is still associated with at least one service body or is the parent of another user.',
    userIsDeactivated: 'User is deactivated.',
    usernameTitle: 'Username',
    usersTitle: 'Users',
    userTitle: 'User',
    userTypeTitle: 'User Type',
    venueTypeTitle: 'Venue Type',
    virtualMeetingAdditionalInfoTitle: 'Virtual Meeting Additional Information',
    virtualMeetingTitle: 'Virtual Meeting Link',
    websiteUrlTitle: 'Web Site URL',
    welcome: 'Welcome',
    worldIdTitle: 'World Committee Code',
    youHaveUnsavedChanges: 'You have unsaved changes. Do you really want to close?',
    zipCodeTitle: 'Zip Code/Postal Code'
  }
});

const LANGUAGE_STORAGE_KEY = 'bmltLanguage';

class Translations {
  private store = writable(strings);

  constructor() {
    const language = localStorage.getItem(LANGUAGE_STORAGE_KEY) || settings.defaultLanguage;
    strings.setLanguage(language);
    this.store.set(strings);
  }

  get subscribe(): (run: Subscriber<typeof strings>) => Unsubscriber {
    return this.store.subscribe;
  }

  getLanguage(): string {
    return strings.getLanguage();
  }

  getAvailableLanguages(): string[] {
    return strings.getAvailableLanguages();
  }

  setLanguage(language: string): void {
    strings.setLanguage(language);
    localStorage.setItem(LANGUAGE_STORAGE_KEY, language);
    this.store.set(strings);
  }

  getString(key: string, language?: string): string {
    return strings.getString(key, language ?? this.getLanguage());
  }

  getTranslationsForLanguage(language: string | null = null): Record<string, string> {
    return strings.getContent()[language ?? this.getLanguage()];
  }

  getTranslationsForAllLanguages(): Record<string, Record<string, string>> {
    return strings.getContent();
  }
}

export const translations = new Translations();
